# Wireless Inexpensive Bathymetry Logger 2.5.1

The files in this directory are the production files required to create v2.5.1 hardware for the Wireless Inexpensive Bathymetry Logger (WIBL) project.

## File Manifest

The included files are:

* [2025-11-22_WIBL_2.5.1_AssemblyDrawing.pdf](2025-11-22_WIBL_2.5.1_AssemblyDrawing.pdf): an assembly drawing that may be required by some board houses to fully specify the production of boards.
* [2025-11-22_WIBL_2.5.1_BOM.csv](2025-11-22_WIBL_2.5.1_BOM.csv): Comma Separated Value file for the Bill of Materials required to populate boards.  The format here is that required for manufacturing at JLCPCB, but other suppliers will likely be able to take this, or something similar.
* [2025-11-22_WIBL_2.5.1_CostEstimates.xlsx](2025-11-22_WIBL_2.5.1_CostEstimates.xlsx): An estimate of the costs required to built a small batch of boards (through JLCPCB) at the time of release of these files.  Due to ongoing tarrifs and other effects, the price is significantly higher than for previous builds, but would likely be ameliorated by larger batches.
* [2025-11-22_WIBL_2.5.1_CPL.csv](2025-11-22_WIBL_2.5.1_CPL.csv): Comma Separated Value file for the placement of components on the board.  The format here is that required for manufacturing at JLCPCB, but other suppliers will likely be able to take this, or something similar.
* [2025-11-22_WIBL_2.5.1_Gerbers.zip](2025-11-22_WIBL_2.5.1_Gerbers.zip): A ZIP file containing the Gerber-format files for manufacturing the PCBs.  Typically, the ZIP file can be uploaded to a board house, and they pick out the layers required (e.g., top copper, bottom copper, silk-screen, etc.)
* [2025-11-22_WIBL_2.5.1_InteractiveBOM.html](2025-11-22_WIBL_2.5.1_InteractiveBOM.html): A self-contained HTML file (with JavaScript) to allow you to explore the Bill of Materials (components required to build the board) in interactive form.  This is useful for procurement purposes, but also for assembly and troubleshooting.
* [2025-11-22_WIBL_2.5.1_MainSchematic.pdf](2025-11-22_WIBL_2.5.1_MainSchematic.pdf): a schematic drawing for the logger, including an overview diagram and operational notes.
* [2025-11-22_WIBL_2.5.1_ODB++.tgz](2025-11-22_WIBL_2.5.1_ODB++.tgz): An alternative to Gerber-format files that might be used by some board houses.
* [2025-11-22_WIBL_2.5.1_PCBLayout.pdf](2025-11-22_WIBL_2.5.1_PCBLayout.pdf): a drawing of the copper layers (top and bottom) and edge cuts required for the PCBs.  This is typically not required for production, but can be useful for debugging and setup.
* [2025-11-22_WIBL_2.5.1_PCBModel.step](2025-11-22_WIBL_2.5.1_PCBModel.step): a 3D mechanical drawing of the PCBs and assembled components, used for designing enclosures.

## Release Notes

This version of the board was the first designed in [KiCAD](https://www.kicad.org), required since the previous tool (Eagle CAD) was announced as losing its open source free status in the near future (bought by a corporation, free for a bit, then ... not).  The design for v2.4.1 in Eagle was imported (forming v2.5.0), but then subsequent modifications, particularly to the power system, necessitated a new release (v2.5.1).  Significant changes include:

* Revised switch-mode power supply controller, increased feedback inductor, and revised layout.  This significantly reduces the loop noise and therefore EMC.
* Revised input voltage monitoring on the 12V supply line, allowing the system to better measure the input voltage (which is now reported in status messages), and switch to emergency shut-down if the power goes off.
* Small updates to decoupling capacitors to improve stability.
* Added four mounting holes (making the PCB a little bigger) to allow for easier manufacturing and more reliable mounting in enclosures.
